package gov.va.med.mhv.admin.repository;

import gov.va.med.mhv.admin.model.SMSUserView;
import gov.va.med.mhv.common.data.model.UserProfile;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface UserProfileSMRepository extends JpaRepository<UserProfile, Long> {

	/**
	 *
	 * @param userName
	 * @return
	 */
	@Query("select smu from SMSUserView smu where lower(smu.externalUserName) = lower(:externalUserName)")
	SMSUserView getSMSUserByExternalUserName(@Param("externalUserName") String externalUserName);

}